#!/bin/bash
# ------------------------------------------------------------------------------
#	Shell script file
#
#  	Copyright(©)   PerkinElmer Cellular Technologies Germany GmbH 2021
#
#  	Description: install and setup systemd for pyrunner/django
#
#		Examples:	installsystemd.sh {/auto}
#					
#		Remark: Version 1.0.0.22077
#
# 		Last change: 
#
#
#    $Date: 2020-07-21 $         $Revision: $
#
# ------------------------------------------------------------------------------

#sudo killall -w -r python*
sudo systemctl is-active pyrunner.service && sudo systemctl stop pyrunner.service
sudo systemctl is-active django.service && sudo systemctl stop django.service
sudo systemctl is-active chownwdog.service && sudo systemctl stop chownwdog.service

sudo mv -f ~/pyrunner.service /etc/systemd/system/pyrunner.service
sudo mv -f ~/django.service /etc/systemd/system/django.service
sudo mv -f ~/chownwdog.service /etc/systemd/system/chownwdog.service
sudo systemctl daemon-reload
sudo systemctl enable pyrunner.service
sudo systemctl enable django.service
sudo systemctl enable chownwdog.service
if [ "$1" = "auto" ]
then
    sudo systemctl start django.service
    sudo systemctl start pyrunner.service
	sudo systemctl start chownwdog.service
    echo PyRunner installed and running....
else
	sudo systemctl start chownwdog.service
    echo PyRunner installed! Reboot required...
fi
echo PyRunner installed...
if [ -f ~/version.sh ]; then
	source ~/version.sh > ~/logs/OSVer.log
fi